/*=======================================================*/
/*
 *  Listing 8.  tstTestDev.c 
 * 
 *  test program for generic user device
*/
/*=======================================================*/

#include <exec/types.h>
#include <exec/memory.h>
#include <exec/io.h>
#include <clib/exec_protos.h>
#include <clib/alib_protos.h>

#include <stdlib.h>
#include <stdio.h>

#include "userdev.h"

void main(void)
{
   struct MsgPort *usrPort = NULL;
   struct IOUsrReq *usrIO = NULL;
   int    i;
   BYTE   err;

   /*
    *  create port
   */

   usrPort = CreateMsgPort();
   if ( ! usrPort )
   {
      printf("Can't create message port\n");
      exit(1);
   }

   /*
    *  create io request
   */

   usrIO = CreateIORequest(usrPort,
                           sizeof(struct IOUsrReq));
   if ( ! usrIO )
   {
      printf("Can't create IO request\n");
      goto allDone;
   }

   printf("Calling OpenDevice for device %s\n",DEV_NAME);

   err = OpenDevice(DEV_NAME,0,
                    (struct IORequest*)usrIO,0);
   if ( err )
   {
      printf("Can't open %s\n",DEV_NAME);
      goto allDone;
   }

   /*
    *  send all the different types of commands
   */

   for ( i = 0; i <= USRDEV_LASTCMD; i++ )
   {
      usrIO->usr_IO.io_Command = i;
      err = DoIO((struct IORequest*)usrIO);
      if ( err )
      {
         printf("DoIO failed\n");
         printf("  error code = %d\n",
                usrIO->usr_IO.io_Error);
      }
   }

   /*
    *  close the device
   */
   
   printf("Calling CloseDevice\n");

   CloseDevice((struct IORequest*)usrIO);

allDone:

   if( usrIO )
      DeleteIORequest(usrIO);

   if( usrPort )
      DeleteMsgPort(usrPort);      

   exit(0);
}
